<?php
declare(strict_types=1);

use Migrations\AbstractSeed;

class ContentBlocksSeed extends AbstractSeed
{
    public function run(): void
    {
        $data = [
            ['parent'=>'global','label'=>'Site Title','description'=>'Site Title','slug'=>'site-title','type'=>'text','value'=>'BrewHub Coffee'],
            ['parent'=>'global','label'=>'Header Menu','description'=>'Header Menu','slug'=>'header-menu','type'=>'html','value'=>'<a href=\"/\">Menu</a> | <a href=\"/shop\">Shop All</a> | <a href=\"/about\">About</a> | <a href=\"/contact\">Contact</a> | <a href=\"/login\">Log in</a>'],
            ['parent'=>'home','label'=>'Hero Heading','description'=>'Hero Heading','slug'=>'hero-heading','type'=>'text','value'=>'Premium Coffee, Roasted with Expertise'],
            ['parent'=>'home','label'=>'Hero Subheading','description'=>'Hero Subheading','slug'=>'hero-sub','type'=>'html','value'=>'Coffee innovators committed to excellence, using cutting-edge technology to lead the industry.'],
            ['parent'=>'home','label'=>'Hero CTA','description'=>'Button','slug'=>'hero-cta','type'=>'html','value'=>'<a class=\"btn\" href=\"/shop\">Shop Now</a>'],
            ['parent'=>'home','label'=>'Home Favourites','description'=>'Favourite Products','slug'=>'home-favourites','type'=>'html','value'=>'<div class=\"fave\">...商品列表或短 html ...</div>'],
            ['parent'=>'home','label'=>'Special Offer','description'=>'Special Offer','slug'=>'special-offer','type'=>'text','value'=>'Special Offer for Limited Time — Enjoy a complimentary coffee tasting session with every purchase!'],
            ['parent'=>'global','label'=>'Our Story','description'=>'Our Story','slug'=>'our-story','type'=>'html','value'=>'<p>We hold ourselves up to the highest of standards, and have been part of this industry since 2000.</p>'],
            ['parent'=>'global','label'=>'Contact Phone','description'=>'Phone','slug'=>'contact-phone','type'=>'text','value'=>'0400 000 000'],
            ['parent'=>'global','label'=>'Contact Email','description'=>'Email','slug'=>'contact-email','type'=>'text','value'=>'info@brewhub.com'],
            ['parent'=>'global','label'=>'Contact Address','description'=>'Address','slug'=>'contact-address','type'=>'text','value'=>'123 Burwood Road, Hawthorn, VIC 3122'],
            ['parent'=>'global','label'=>'Footer HTML','description'=>'Footer','slug'=>'footer-html','type'=>'html','value'=>'<p>© 2025 BrewHub Coffee. Powered by WebSpire.</p><ul><li>Facebook</li><li>Instagram</li></ul>'],
            ['parent'=>'global','label'=>'AI Widget','description'=>'AI Widget','slug'=>'ai-widget','type'=>'html','value'=>'<div class=\"ai\">BrewBot • Coffee help</div>']
        ];

        $table = $this->table('content_blocks');
        $table->insert($data)->save();
    }
}
