<?php
declare(strict_types=1);

namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;

class AdminContentBlocksController extends AppController
{
    public function initialize(): void
    {
        parent::initialize();
    }
    private function isAdmin(): bool
    {
        $id = $this->request->getAttribute('identity');
        return (bool)($id && $id->get('role') === 'admin');
    }

    public function index()
    {
        if (!$this->isAdmin()) {
            throw new \Cake\Http\Exception\ForbiddenException('Admins only.');
        }
        $contentBlocksTable = TableRegistry::getTableLocator()->get('ContentBlocks.ContentBlocks');
        $blocks = $contentBlocksTable->find()->all();
        $this->set(compact('blocks'));
    }

    public function edit($id)
    {
        if (!$this->isAdmin()) {
            throw new \Cake\Http\Exception\ForbiddenException('Admins only.');
        }
        $contentBlocksTable = TableRegistry::getTableLocator()->get('ContentBlocks.ContentBlocks');
        $block = $contentBlocksTable->get($id);

        if ($this->request->is(['post', 'put'])) {
            $contentBlocksTable->patchEntity($block, $this->request->getData());
            if ($contentBlocksTable->save($block)) {
                $this->Flash->success('Saved successfully');
                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error('Save failed');
        }

        $this->set(compact('block'));
    }

}
