<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;

class LandingPagesTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);
        $this->setTable('landing_pages');
        $this->setPrimaryKey('id');
        $this->setDisplayField('hero_title');
    }
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->scalar('hero_title')
            ->maxLength('hero_title', 255)
            ->requirePresence('hero_title', 'create')
            ->notEmptyString('hero_title');

        $validator
            ->scalar('hero_subtitle')
            ->maxLength('hero_subtitle', 255)
            ->allowEmptyString('hero_subtitle');

        $validator
            ->scalar('promo_copy')
            ->allowEmptyString('promo_copy');

        $validator
            ->scalar('featured_products')
            ->allowEmptyString('featured_products');

        return $validator;
    }
}

