<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

class UserPreferencesTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('user_preferences');
        $this->setPrimaryKey('id');
        $this->setDisplayField('pref_key');

        $this->addBehavior('Timestamp');

        $this->belongsTo('Users', [
            'foreignKey' => 'user_id',
            'joinType'   => 'INNER',
        ]);
    }

    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->nonNegativeInteger('user_id')
            ->requirePresence('user_id', 'create')
            ->notEmptyString('user_id');

        $validator
            ->scalar('pref_key')
            ->maxLength('pref_key', 100)
            ->requirePresence('pref_key', 'create')
            ->notEmptyString('pref_key');

        $validator
            ->scalar('pref_value')
            ->maxLength('pref_value', 255)
            ->requirePresence('pref_value', 'create')
            ->notEmptyString('pref_value');

        return $validator;
    }

    public function buildRules(RulesChecker $rules): RulesChecker
    {
        // FK: user must exist
        $rules->add($rules->existsIn(['user_id'], 'Users'), [
            'errorField' => 'user_id',
            'message' => 'User not found.'
        ]);

        // Unique (user_id, pref_key)
        $rules->add($rules->isUnique(
            ['user_id', 'pref_key'],
            'This preference key already exists for the user.'
        ));

        return $rules;
    }
}

