<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ContentBlock $block
 */
?>
<style>
    .form input,
    .form textarea,
    .form select {
        display: block;
        width: 100%;
        margin-bottom: 15px;
    }
    .row {
        margin-left: auto;
        margin-right: auto;
        max-width: 900px;
        padding: 0 15px;
    }
    @media (max-width: 768px) {
        .row {
            max-width: 100%;
            padding: 0 10px;
        }
    }
</style>

<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $block->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $block->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Content Blocks'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>

    <div class="column column-80">
        <div class="blocks form content">
            <?= $this->Form->create($block) ?>
            <fieldset>
                <legend><?= __('Edit Content Block') ?></legend>
                <div style="display:flex; gap:10px; flex-wrap:wrap;">
                    <div style="flex:1; min-width:200px;">
                        <?= $this->Form->control('slug', ['required' => true]) ?>
                    </div>
                </div>
                <?= $this->Form->control('value', ['type'=>'textarea', 'rows'=>5, 'required'=>true]) ?>
            </fieldset>
            <?= $this->Form->button(__('Save')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
