<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\ContentBlock> $blocks
 */
?>
<h1 style="text-align: center" class="headline">Content Management</h1>

<style>
    div.dt-container {
        margin: 0 auto;
        width: 90%;
    }
    table.dataTable td {
        white-space: nowrap;
    }
    .headline {
        font-family: "Playfair Display", serif;
    }
</style>

<link rel="stylesheet" href="https://cdn.datatables.net/2.3.4/css/dataTables.dataTables.css" />
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/3.0.3/css/responsive.dataTables.min.css" />
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/2.3.4/js/dataTables.js"></script>
<script src="https://cdn.datatables.net/responsive/3.0.3/js/dataTables.responsive.min.js"></script>

<div style="display: flex; justify-content: center">
    <table id="ContentTable" class="display">
        <thead>
        <tr>
            <th>Slug</th>
            <th>Action</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($blocks as $block): ?>
            <tr>
                <td><?= h($block->slug) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('Edit'), ['action' => 'edit', $block->id], ['class' => 'button', 'style' => 'padding:5px 10px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;']) ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
<script>
    $(document).ready(function () {
        $('#ContentTable').DataTable({
            responsive: true,
            paging: true,
            searching: true,
            ordering: true,
            info: true,
            lengthMenu: [10, 25, 50, 100]
        });
    });
</script>
