<?php
/**
 * @var \App\View\AppView $this
 */

use Cake\Core\Configure;

$debug = Configure::read('debug');


$this->assign('title', 'Login');
?>
<style>
    .login-wrapper {
        display:flex;
        justify-content:center;
        align-items:center;
        min-height:70vh;
        padding:20px;
    }
    .login-card {
        background:#fff;
        border-radius:16px;
        box-shadow:0 8px 24px rgba(0,0,0,0.1);
        padding:40px;
        max-width:420px;
        width:100%;
        text-align:center;
    }
    .login-title {
        font-family:"Playfair Display", serif;
        font-size:28px;
        margin-bottom:24px;
        color:#3b302a;
    }
    .login-input {
        width:100%;
        margin-bottom:16px;
        padding:10px 12px;
        border-radius:6px;
        border:1px solid #ccc;
    }
    .login-btn {
        background-color:#3b302a;
        color:white;
        border:none;
        padding:12px;
        border-radius:8px;
        width:100%;
        font-size:16px;
        cursor:pointer;
        transition: background 0.3s;
    }
    .login-btn:hover {
        background-color:#57463d;
    }
    .login-links {
        margin-top:20px;
        display:flex;
        flex-direction:column;
        gap:10px;
    }
    .login-links a {
        font-size:14px;
        color:#3b302a;
        text-decoration:underline;
    }
    .login-label {
        display:block;
        text-align:left;
        font-weight:500;
        margin-bottom:6px;
        color:#3b302a;
        font-size:14px;
    }

</style>
<div class="login-wrapper">
    <div class="login-card">
        <h2 class="login-title">Welcome Back</h2>
        <?= $this->Form->create() ?>
        <?= $this->Flash->render() ?>
        <?= $this->Form->control('email', [
            'type'=>'email',
            'required'=>true,
            'autofocus'=>true,
            'label'=>'Email',
            'value'=>$debug ? "test@example.com" : "",
            'class'=>'login-input',
            'templates' => [
                'label' => '<label class="login-label">{{text}}</label>'
            ]
        ]) ?>

        <?= $this->Form->control('password', [
            'type'=>'password',
            'required'=>true,
            'label'=>'Password',
            'value'=>$debug ? '1234' : '',
            'class'=>'login-input',
            'templates' => [
                'label' => '<label class="login-label">{{text}}</label>'
            ]
        ]) ?>

        <div class="captcha-wrap <?= $this->Form->isFieldError('g-recaptcha-response') ? 'has-error' : '' ?>">
            <div class="g-recaptcha"
                 data-sitekey="<?= h(\Cake\Core\Configure::read('Recaptcha.site')) ?>">
            </div>
            <?= $this->Form->error('g-recaptcha-response', null, ['class' => 'error']) ?>
        </div>
        <br>
        <?= $this->Form->button('Login', ['class'=>'login-btn']) ?>
        <?= $this->Form->end() ?>
        <div class="login-links">
            <?= $this->Html->link('Forgot password?', ['controller'=>'Auth','action'=>'forgetPassword']) ?>
            <?= $this->Html->link('Register new user', ['controller'=>'Auth','action'=>'register']) ?>
            <?= $this->Html->link('Go to Homepage', '/') ?>
        </div>
    </div>
</div>


    <!-- RECAPTCHA SCRIPT -->
<?= $this->Html->script('https://www.google.com/recaptcha/api.js', ['async' => true, 'defer' => true]) ?>
