<?php
$this->assign('title', 'Register new user');
?>
<style>
    .register-wrapper {
        display:flex;
        justify-content:center;
        align-items:center;
        min-height:70vh;
        padding:20px;
    }
    .register-card {
        background:#fff;
        border-radius:16px;
        box-shadow:0 8px 24px rgba(0,0,0,0.1);
        padding:40px;
        max-width:480px;
        width:100%;
        text-align:center;
    }
    .register-title {
        font-family:"Playfair Display", serif;
        font-size:28px;
        margin-bottom:24px;
        color:#3b302a;
    }
    .register-label {
        display:block;
        text-align:left;
        font-weight:500;
        margin-bottom:6px;
        color:#3b302a;
        font-size:14px;
    }
    .register-input {
        width:100%;
        margin-bottom:16px;
        padding:10px 12px;
        border-radius:6px;
        border:1px solid #ccc;
    }
    .register-btn {
        background-color:#3b302a;
        color:white;
        border:none;
        padding:12px;
        border-radius:8px;
        width:100%;
        font-size:16px;
        cursor:pointer;
        transition: background 0.3s;
    }
    .register-btn:hover {
        background-color:#57463d;
    }
    .register-links {
        margin-top:20px;
        display:flex;
        flex-direction:column;
        gap:10px;
    }
    .register-links a {
        font-size:14px;
        color:#3b302a;
        text-decoration:underline;
    }
    .row {
        display:flex;
        gap:10px;
    }
    .row .column {
        flex:1;
    }
</style>

<div class="register-wrapper">
    <div class="register-card">
        <h2 class="register-title">Register New User</h2>

        <?= $this->Form->create($user, ['type'=>'file']) ?>
        <?= $this->Flash->render() ?>

        <?= $this->Form->control('email', [
            'label'=>'Email',
            'class'=>'register-input',
            'templates'=>['label'=>'<label class="register-label">{{text}}</label>']
        ]) ?>

        <div class="row">
            <?= $this->Form->control('first_name', [
                'label'=>'First Name',
                'class'=>'register-input column',
                'templates'=>['label'=>'<label class="register-label">{{text}}</label>']
            ]) ?>
            <?= $this->Form->control('last_name', [
                'label'=>'Last Name',
                'class'=>'register-input column',
                'templates'=>['label'=>'<label class="register-label">{{text}}</label>']
            ]) ?>
        </div>

        <div class="row">
            <?= $this->Form->control('password', [
                'type'=>'password',
                'label'=>'Password',
                'class'=>'register-input column',
                'templates'=>['label'=>'<label class="register-label">{{text}}</label>']
            ]) ?>
            <?= $this->Form->control('password_confirm', [
                'type'=>'password',
                'label'=>'Retype Password',
                'class'=>'register-input column',
                'templates'=>['label'=>'<label class="register-label">{{text}}</label>']
            ]) ?>
        </div>

        <?= $this->Form->button('Register', ['class'=>'register-btn']) ?>
        <?= $this->Form->end() ?>

        <div class="register-links">
            <?= $this->Html->link('Back to login', ['controller'=>'Auth','action'=>'login']) ?>
        </div>
    </div>
</div>
