<?php
$this->assign('title', 'Reset Password');
?>
<style>
    .reset-wrapper {
        display:flex;
        justify-content:center;
        align-items:center;
        min-height:70vh;
        padding:20px;
    }
    .reset-card {
        background:#fff;
        border-radius:16px;
        box-shadow:0 8px 24px rgba(0,0,0,0.1);
        padding:40px;
        max-width:420px;
        width:100%;
        text-align:center;
    }
    .reset-title {
        font-family:"Playfair Display", serif;
        font-size:28px;
        margin-bottom:24px;
        color:#3b302a;
    }
    .reset-label {
        display:block;
        text-align:left;
        font-weight:500;
        margin-bottom:6px;
        color:#3b302a;
        font-size:14px;
    }
    .reset-input {
        width:100%;
        margin-bottom:16px;
        padding:10px 12px;
        border-radius:6px;
        border:1px solid #ccc;
    }
    .reset-btn {
        background-color:#3b302a;
        color:white;
        border:none;
        padding:12px;
        border-radius:8px;
        width:100%;
        font-size:16px;
        cursor:pointer;
        transition: background 0.3s;
    }
    .reset-btn:hover {
        background-color:#57463d;
    }
    .login-links {
        margin-top:20px;
        display:flex;
        flex-direction:column;
        gap:10px;
    }
    .login-links a {
        font-size:14px;
        color:#3b302a;
        text-decoration:underline;
    }
</style>

<div class="reset-wrapper">
    <div class="reset-card">
        <h2 class="reset-title">Reset Your Password</h2>

        <?= $this->Form->create($user) ?>
        <?= $this->Flash->render() ?>

        <?= $this->Form->control('password', [
            'type'=>'password',
            'required'=>true,
            'autofocus'=>true,
            'label'=>'New Password',
            'class'=>'reset-input',
            'templates'=>[
                'label' => '<label class="reset-label">{{text}}</label>'
            ]
        ]) ?>

        <?= $this->Form->control('password_confirm', [
            'type'=>'password',
            'required'=>true,
            'label'=>'Repeat New Password',
            'class'=>'reset-input',
            'templates'=>[
                'label' => '<label class="reset-label">{{text}}</label>'
            ]
        ]) ?>

        <?= $this->Form->button('Reset Password', ['class'=>'reset-btn']) ?>
        <?= $this->Form->end() ?>

        <div class="login-links">
            <?= $this->Html->link('Back to login', ['controller'=>'Auth','action'=>'login']) ?>
        </div>
    </div>
</div>
