<?php
$this->assign('title', 'Your Cart');
?>
<style>
    table.cart {width:100%; border-collapse: collapse; margin: 20px 0;table-layout: fixed;}
    table.cart th, table.cart td {padding:12px; border-bottom:1px solid #e2dcd2; text-align:center;}
    table.cart img {width:70px; height:auto; border-radius:8px;margin:auto}
    .cart-actions {display:flex; gap:12px; margin-top:20px;}
    .total {font-size:20px; font-weight:700; text-align:right; margin-top:20px;}
    .qty-input {width:60px; padding:4px 6px; text-align:center;}
    @media (max-width: 768px) {
        div[style*="margin:0 170px"] {
            margin: 0 20px !important;
        }

        table.cart {
            font-size: 14px;
        }

        table.cart th, table.cart td {
            padding: 8px 4px;
        }
        table.cart img {
            width: 50px;
        }
        .qty-input {
            width: 50px;
            padding: 3px 4px;
        }
        .total {
            font-size: 18px;
        }
        .cart-actions {
            flex-wrap: wrap;
            justify-content: center;
        }
        .button {
            font-size: 14px !important;
            padding: 8px 16px !important;
        }
    }
    @media (max-width: 480px) {
        div[style*="margin:0 170px"] {
            margin: 0 10px !important;
        }
        table.cart {
            font-size: 12px;
        }
        table.cart th, table.cart td {
            padding: 6px 2px;
        }
        table.cart img {
            width: 40px;
        }
        .qty-input {
            width: 40px;
            padding: 2px 3px;
        }
        .total {
            font-size: 16px;
        }
        h1 {
            font-size: 24px;
        }
        .button {
            font-size: 12px !important;
            padding: 6px 12px !important;
        }
    }
</style>
<div style="margin:0 170px">
    <h1>Your Shopping Cart</h1>
    <?php if (empty($items)): ?>
        <p>Your cart is empty.</p>
        <?= $this->Html->link('Continue Shopping', ['controller'=>'ProductBrowser','action'=>'index'], ['class'=>'button']) ?>
    <?php else: ?>
        <table class="cart">
            <thead>
            <tr>
                <th>Product</th>
                <th>Price</th>
                <th>Quantity</th>
                <th>Subtotal</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($items as $item): ?>
                <tr>
                    <td>
                        <?php
                        $img = $item['product']->image_url[0] ?? '/img/placeholder.png';
                        $cleanPath = str_replace('\\', '/', $img);
                        $imgUrl = $this->Url->image('products/' . basename($cleanPath), ['fullBase' => true]);
                        ?>
                        <img src="<?= h($imgUrl) ?>" alt="">

                        <?= h($item['product']->name) ?>
                    </td>
                    <td>$<?= number_format($item['price'], 2) ?></td>
                    <td>
                        <?= $this->Form->create(null, [
                            'url' => ['controller'=>'Cart','action'=>'update',$item['product']->id],
                            'style'=>'display:inline'
                        ]) ?>
                        <?= $this->Form->hidden('id', ['value' => $item['product']->id]) ?>
                        <?= $this->Form->number('qty', [
                            'value'=>$item['qty'],
                            'class'=>'qty-input',
                            'min'=>0,
                            'max' => $item['product']->stock,
                            'onchange' => "updateQty(this, {$item['product']->stock}, {$item['qty']})"
                        ]) ?>
                        <?= $this->Form->end() ?>
                    </td>
                    <td>$<?= number_format($item['subtotal'], 2) ?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        <div style="display:flex; justify-content:space-between; align-items:center; margin-top:20px;">
            <div class="total">
                Total: $<?= number_format($total, 2) ?>
            </div>
            <div style="display:flex; gap:12px;">
                <?= $this->Html->link('Continue Shopping',
                    ['controller'=>'ProductBrowser','action'=>'index'],
                    ['class'=>'button', 'style'=>'padding:10px 20px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;']) ?>
                <?= $this->Form->postLink('Clear Cart',
                    ['controller'=>'Cart','action'=>'clear'],
                    ['class'=>'button', 'style'=>'padding:10px 20px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;', 'confirm'=>'Clear all items?']) ?>
                <?= $this->Html->link('Checkout',
                    ['controller'=>'Orders','action'=>'checkout'],
                    ['class'=>'button', 'style'=>'padding:10px 20px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;']) ?>
            </div>
        </div>
    <?php endif; ?>
</div>
<br><br><br><br><br><br><br><br><br><br>
<script>
    function updateQty(input, maxStock, originalQty) {
        var newQty = parseInt(input.value);
        if (newQty > maxStock) {
            input.value = originalQty;
            alert('Quantity cannot exceed available stock (' + maxStock + ').');
            return;
        }
        if (newQty >= 0) {
            input.form.submit();
        }
    }
</script>
