<?php
$this->assign('title', 'Orders');

$statuses = $statuses ?? ['waiting','approved','processing','completed','canceled'];
$opts = array_combine($statuses, array_map('ucfirst', $statuses));

$term   = isset($q) ? $q : (string)$this->request->getQuery('q');
$status = isset($status) ? $status : (string)$this->request->getQuery('status');
?>
<h1 style="text-align: center" class="headline">Manage Orders</h1>
<div style="display: flex; justify-content: center; gap: 10px; margin-bottom: 10px; align-items: center;">
  <?= $this->Form->create(null, ['type'=>'get', 'style'=>'display:flex; gap:10px; align-items:center;']) ?>
    <?= $this->Form->control('q', [
          'label'=>false,
          'placeholder'=>'Search order # or email',
          'value'=>$term,
          'style'=>'padding:8px 10px;'
    ]) ?>
    <?= $this->Form->select('status', [''=>'All statuses'] + $opts, [
          'value'=>$status,
          'style'=>'padding:8px 10px;'
    ]) ?>
    <?= $this->Form->button('Filter', [
          'style'=>'padding:10px 20px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;'
    ]) ?>
  <?= $this->Html->link(__('Archived Orders'), ['action' => 'archived'],  ['class' => 'button', 'style' => 'padding:10px 20px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;']) ?>
  <?= $this->Form->end() ?>
</div>


<style>
.headline {font-family:"Playfair Display", serif; text-align:center; margin-bottom:20px;}
div.dt-container {margin:0 auto; width:95%;}
table.dataTable td {white-space: nowrap;}
.pill{padding:4px 10px;border-radius:999px;font-size:12px;display:inline-block}
.pill.waiting{background:#fff1cc}
.pill.approved{background:#e6ffed}
.pill.processing{background:#e6f0ff}
.pill.completed{background:#e8e5ff}
.pill.canceled{background:#ffe6e6}
.status-wrap{display:flex; align-items:center; gap:8px}
.status-edit{display:none}
.status-change{font-size:12px; color:#6b5a49; text-decoration:underline; cursor:pointer}
</style>

<link rel="stylesheet" href="https://cdn.datatables.net/2.3.4/css/dataTables.dataTables.css" />
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/3.0.3/css/responsive.dataTables.min.css" />
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/2.3.4/js/dataTables.js"></script>
<script src="https://cdn.datatables.net/responsive/3.0.3/js/dataTables.responsive.min.js"></script>

<div class="dt-container">
    <table id="Table" class="display">
        <thead>
            <tr>
                <th>Order No.</th>
                <th>Date</th>
                <th>Customer</th>
                <th style="text-align:right;">Items</th>
                <th style="text-align:right;">Total</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($orders as $o): ?>
            <tr>
                <td><?= h($o->order_no) ?></td>
                <td><?= $o->created ? $o->created->format('d-m-Y H:i') : '' ?></td>
                <td><?= h($o->customer_name ?: ($o->customer_email ?? $o->email ?? 'Guest')) ?></td>
                <td style="text-align:right;"><?= (int)($o->items_count ?? 0) ?></td>
                <td style="text-align:right;">$<?= number_format((float)($o->total ?? 0), 2) ?></td>
                <td>
                    <div class="status-wrap" data-row="<?= (int)$o->id ?>">
                        <span class="pill <?= h($o->status) ?> js-pill"><?= h(ucfirst($o->status)) ?></span>
                        <a class="status-change js-edit" href="javascript:void(0)">Change</a>
                        <div class="status-edit js-form">
                            <?= $this->Form->create(null, ['url'=>['action'=>'setStatus',$o->id],'type'=>'post','class'=>'inline-form']) ?>
                                <?= $this->Form->select('status', $opts, ['value'=>$o->status,'label'=>false]) ?>
                                <?= $this->Form->button('Save', ['style'=>'padding:3px 6px; margin-left:5px;']) ?>
                                <a class="status-change js-cancel" href="javascript:void(0)">Cancel</a>
                            <?= $this->Form->end() ?>
                        </div>
                    </div>
                </td>
                <td>
                    <button onclick="window.location.href='<?= $this->Url->build(['controller' => 'Orders', 'action' => 'adminView', $o->id]) ?>'"
        class="button"
        style="padding:5px 10px; font-size:14px; background-color:#3b302a; color:white; border-radius:5px; border:none; cursor:pointer;">
    View
</button>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
    $(document).ready(function () {
        const table = $('#Table').DataTable({
            responsive: true,
            paging: true,
            searching: false,
            ordering: true,
            info: true,
            lengthMenu: [10, 25, 50, 100]
        });
        $('#Table tbody').on('click', '.js-edit', function () {
            const $wrap = $(this).closest('.status-wrap');
            $wrap.find('.js-form').show();
            $wrap.find('.js-edit').hide();
            $wrap.find('.js-pill').hide();
        });

        $('#Table tbody').on('click', '.js-cancel', function () {
            const $wrap = $(this).closest('.status-wrap');
            $wrap.find('.js-form').hide();
            $wrap.find('.js-edit').show();
            $wrap.find('.js-pill').show();
        });

        function bindStatusEvents() {
            $('.status-wrap').each(function () {
                const $row = $(this);
                const $editLink = $row.find('.js-edit');
                const $cancelLink = $row.find('.js-cancel');
                const $pill = $row.find('.js-pill');
                const $form = $row.find('.js-form');
                function showForm(show) {
                    $form.toggle(show);
                    $editLink.toggle(!show);
                    $pill.toggle(!show);
                }
                showForm(false);
                $editLink.off('click').on('click', () => showForm(true));
                $cancelLink.off('click').on('click', () => showForm(false));
            });
        }
        bindStatusEvents();
        table.on('draw', bindStatusEvents);
    });
</script>
