<?php
$this->assign('title', 'Checkout');
?>
<style>
.page{max-width:1160px;margin:28px auto;padding:0 16px}
.grid{display:grid;grid-template-columns:1.6fr .9fr;gap:36px}
.card{background:#fff;border-radius:16px;box-shadow:0 8px 24px rgba(0,0,0,.06)}
.list{padding:6px 18px}
.row{display:grid;grid-template-columns:120px 1fr 140px 80px 28px;gap:16px;align-items:center;padding:18px 0;border-bottom:1px solid #eee}
.row:last-child{border-bottom:0}
.img{width:100px;height:120px;display:flex;align-items:center;justify-content:center;background:#fff;border:1px solid #eee;border-radius:12px;overflow:hidden}
.img img{max-width:100%;max-height:100%;object-fit:contain}
.name{font-weight:600;margin:0 0 6px}
.meta{color:#6d5f54;font-size:14px}
.price{font-weight:700}
.trash{background:none;border:0;font-size:18px;cursor:pointer;opacity:.7}
.qtybox{display:flex;align-items:center;gap:8px}
.qtybox form{display:inline}
.qtybtn{width:36px;height:32px;border:1px solid #d9cfc2;border-radius:8px;background:#fff;cursor:pointer}
.qtynum{min-width:28px;text-align:center}
.panel{padding:20px}
.panel h3{margin:0 0 14px}
.sumrow{display:flex;justify-content:space-between;margin:8px 0}
.total{font-weight:800;font-size:20px}
.btn{display:block;width:100%;text-align:center;background:#3b302a;color:#fff;border:0;border-radius:12px;padding:14px 18px;font-size:16px;cursor:pointer}
.note, .promo{display:flex;gap:12px;align-items:center;margin-top:16px}
.note input,.promo input{flex:1;border:1px solid #e3d7c3;border-radius:10px;padding:10px 12px}
.helper{color:#6d5f54;font-size:13px;margin-top:10px;display:flex;align-items:center;gap:8px}
@media(max-width:980px){.grid{grid-template-columns:1fr}}
</style>

<div class="page">
  <h1>My cart</h1>
  <?php if (empty($items)): ?>
    <div class="card panel">
      Your cart is empty.
      <div style="margin-top:12px">
        <?= $this->Html->link('Continue Shopping', ['controller'=>'ProductBrowser','action'=>'index'], ['class'=>'btn', 'style'=>'width:auto;display:inline-block']) ?>
      </div>
    </div>
  <?php else: ?>
    <div class="grid">
      <!-- LEFT: items -->
      <div class="card list">
        <?php foreach ($items as $it): $p = $it['product']; ?>
  <?php
    $images = [];
    if (!empty($p->image_url)) {
        if (is_array($p->image_url)) $images = $p->image_url;
        else $images = json_decode($p->image_url, true);
    }
    $firstImage = isset($images[0]) ? str_replace('\\','',$images[0]) : null;
    if ($firstImage) $firstImage = 'products/' . basename($firstImage);
    elseif (!empty($p->image)) $firstImage = 'products/' . ltrim((string)$p->image, '/');
    else $firstImage = '/img/placeholder.png';
  ?>
  <div class="row">
    <div class="img">
      <img src="<?= $this->Url->image($firstImage) ?>" alt="<?= h($p->name) ?>">
    </div>

    <div>
      <div class="name"><?= h($p->name) ?></div>
      <?php if (isset($p->sale_price) && $p->sale_price !== null && (float)$p->sale_price < (float)$p->price): ?>
        <div class="meta"><s>$<?= number_format((float)$p->price,2) ?></s> $<?= number_format((float)$p->sale_price,2) ?></div>
      <?php else: ?>
        <div class="meta">$<?= number_format((float)$it['price'],2) ?></div>
      <?php endif; ?>
      <div class="meta">Weight: <?= h($p->weight ?? '250g') ?></div>
    </div>

      <div class="qtybox">
          <!-- minus -->
          <?= $this->Form->create(null, ['url'=>['action'=>'checkout']]) ?>
          <?= $this->Form->hidden('action', ['value'=>'update_qty']) ?>
          <?= $this->Form->hidden('id', ['value'=>$p->id]) ?>
          <?= $this->Form->hidden('qty', ['value'=>max(0,$it['qty']-1)]) ?>
          <button class="qtybtn">−</button>
          <?= $this->Form->end() ?>

          <div class="qtynum"><?= h($it['qty']) ?></div>

          <!-- plus -->
          <?= $this->Form->create(null, ['url'=>['action'=>'checkout']]) ?>
          <?= $this->Form->hidden('action', ['value'=>'update_qty']) ?>
          <?= $this->Form->hidden('id', ['value'=>$p->id]) ?>
          <?= $this->Form->hidden('qty', ['value'=>$it['qty']+1]) ?>
          <button class="qtybtn">+</button>
          <?= $this->Form->end() ?>
      </div>

    <div class="price">$<?= number_format((float)$it['subtotal'],2) ?></div>

      <div>
          <?= $this->Form->create(null, ['url'=>['action'=>'checkout']]) ?>
          <?= $this->Form->hidden('action', ['value'=>'remove_item']) ?>
          <?= $this->Form->hidden('id', ['value'=>(int)$p->id]) ?>
          <button class="trash" aria-label="remove">🗑️</button>
          <?= $this->Form->end() ?>
      </div>

  </div>
<?php endforeach; ?>


        <!-- promo & note -->
        <div class="promo">
          <?= $this->Form->create(null, ['url'=>['action'=>'checkout'], 'type'=>'post']) ?>
            <?= $this->Form->hidden('action', ['value'=>'apply_promo']) ?>
            <?= $this->Form->control('promo', ['label'=>false, 'value'=>$promo ?? '', 'placeholder'=>'Enter a promo code']) ?>
            <button class="qtybtn" style="height:40px">Apply</button>
          <?= $this->Form->end() ?>
        </div>

        <div class="note">
          <?= $this->Form->create(null, ['url'=>['action'=>'checkout'], 'type'=>'post']) ?>
            <?= $this->Form->hidden('action', ['value'=>'save_note']) ?>
            <?= $this->Form->control('note', ['label'=>false, 'value'=>$note ?? '', 'placeholder'=>'Add a note']) ?>
            <button class="qtybtn" style="height:40px">Save</button>
          <?= $this->Form->end() ?>
        </div>
      </div>

      <!-- RIGHT: summary -->
      <aside class="card panel">
        <h3>Order summary</h3>
        <div class="sumrow"><span>Subtotal</span><span>$<?= number_format((float)$subtotal, 2) ?></span></div>
        <!-- If you add discounts later, show them here -->
        <div class="sumrow total"><span>Total</span><span>$<?= number_format((float)$total, 2) ?></span></div>
          <?= $this->Form->create(null, ['url'=>['action'=>'place'], 'type'=>'post']) ?>
          <button class="btn" style="margin-top:12px">Pay at Pickup</button>
        <?= $this->Form->end() ?>
          <?= $this->Form->create(null, ['url'=>['action'=>'pay'], 'type'=>'post']) ?>
          <button class="btn" style="margin-top:12px">Pay with Card (Stripe)</button>
          <?= $this->Form->end() ?>
        <div class="helper">🔒 Secure Checkout</div>
      </aside>
    </div>
  <?php endif; ?>
</div>
