<?php
/**
 * @var \App\Model\Entity\Order|null $order
 * @var string $orderNo
 */
$this->assign('title', 'Thank you');
?>
<div style="max-width:780px;margin:40px auto;padding:0 16px">
  <h1>Thanks for your order!</h1>

  <p>
    We’ve received your order.
    <?php if (!empty($orderNo)): ?>
      Your order number is <strong><?= h($orderNo) ?></strong>.
    <?php endif; ?>
  </p>

  <?php if ($order): ?>
    <?php
      // Ensure numeric types; NumberHelper rejects null
      $subtotal = (float)($order->subtotal ?? 0);
      $discount = (float)($order->discount ?? 0);
      $total    = (float)($order->total ?? 0);
    ?>
    <hr>
    <h3>Order summary</h3>

    <?php if (!empty($order->order_items)): ?>
      <ul style="list-style:none;padding:0;margin:0 0 10px 0;">
        <?php foreach ($order->order_items as $it): ?>
          <li style="display:flex;justify-content:space-between;margin:6px 0;">
            <span><?= h($it->name) ?> × <?= (int)$it->qty ?></span>
            <span><?= $this->Number->currency((float)($it->line_total ?? 0)) ?></span>
          </li>
        <?php endforeach; ?>
      </ul>
    <?php endif; ?>

    <p style="display:flex;justify-content:space-between;">
      <span>Subtotal</span>
      <span><?= $this->Number->currency($subtotal) ?></span>
    </p>
    <p style="display:flex;justify-content:space-between;">
      <span>Discount</span>
      <span><?= $this->Number->currency($discount) ?></span>
    </p>
    <p style="display:flex;justify-content:space-between;font-weight:700;">
      <span>Total</span>
      <span><?= $this->Number->currency($total) ?></span>
    </p>
  <?php endif; ?>

  <div style="margin-top:24px;">
    <?= $this->Html->link(
      'Back to Product Page',
      ['controller' => 'ProductBrowser', 'action' => 'index'],  // change if your listing controller differs
      ['style' => 'display:inline-block;background:#2e221b;color:#fff;padding:10px 16px;border-radius:8px;text-decoration:none;']
    ) ?>
  </div>
</div>

