<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Product $product
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $product->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $product->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Products'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="products form content">
             <?= $this->Form->create($product, ['type' => 'file']) ?>
            <?= $this->Form->control('name') ?>
            <?= $this->Form->control('price') ?>
            <?= $this->Form->control('sale_price') ?>
            <?= $this->Form->control('category') ?>

<!-- File upload -->
            <?= $this->Form->control('image_file', [
                'type' => 'file',
                'label' => 'Product image (PNG/JPG/WebP)',
                'accept' => '.png,.jpg,.jpeg,.webp'
            ]) ?>

            <?= $this->Form->button(__('Update')) ?>
            <?= $this->Form->end() ?>
            <fieldset>
                <legend><?= __('Edit Product') ?></legend>
                <?php
                    echo $this->Form->control('name');
                    echo $this->Form->control('description');
                    echo $this->Form->control('price');
                    echo $this->Form->control('sku');
                    echo $this->Form->control('stock');
                    echo $this->Form->control('options');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
