<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Product $product
 */
?>
<style>
    .form input,
    .form textarea,
    .form select {
        display: block;
        width: 100%;
        margin-bottom: 15px;
    }
    .row {
        margin-left: auto;
        margin-right: auto;
        max-width: 900px;
        padding: 0 15px;
    }
    @media (max-width: 768px) {
        .row {
            max-width: 100%;
            padding: 0 10px;
        }
    }
</style>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Add Product') ?></h4>
            <?= $this->Html->link(__('Back'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="products form content">
            <?= $this->Form->create($product, ['type' => 'file']) ?>
            <fieldset>
                <legend><?= __('Add Product') ?></legend>
                <div style="display:flex; gap:10px; flex-wrap:wrap;">
                    <div style="flex:1; min-width:100px;">
                        <?= $this->Form->control('name',['required'=>true]) ?>
                    </div>
                    <div style="flex:1; min-width:100px;">
                        <?= $this->Form->control('price',['type'=>'number','required'=>true,'min'=>0,'max'=>999]) ?>
                    </div>
                    <div style="flex:1; min-width:100px;">
                        <?= $this->Form->control('sku',['required'=>true]) ?>
                    </div>
                    <div style="flex:1; min-width:100px;">
                        <?= $this->Form->control('stock',['type'=>'number','required'=>true,'min'=>0,'max'=>99999]) ?>
                    </div>
                    <div style="flex:1; min-width:100px;">
                        <?= $this->Form->control('threshold',['min'=>0,'max'=>1000]) ?>
                    </div>
                    <div style="flex:1; min-width:100px;">
                        <?= $this->Form->control('category', [
                            'type' => 'select',
                            'options' => ['Blends' => 'Blends', 'Single-Origin' => 'Single-Origin', 'Sustainable' => 'Sustainable'],
                            'required' => true
                        ]) ?>
                    </div>
                </div>
                <?= $this->Form->control('description') ?>
                <?php
                if (!empty($product->image_url)) {
                    echo '<div class="existing-images">';
                    echo '<h4>Current Images:</h4>';
                    foreach ($product->image_url as $imageUrl) {
                        echo '<img src="' . h($imageUrl) . '" style="width: 100px; height: 100px; margin: 5px; display:inline-block;" />';
                    }
                    echo '</div>';
                }
                echo $this->Form->control('image_url[]', [
                    'type' => 'file',
                    'multiple' => true,
                    'label' => 'New Images',
                    'required' => false,
                    'accept' => 'image/*'
                ]);
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
