<!DOCTYPE html>
<html>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js" integrity="sha384-0pUGZvbkm6XF6gxjEnlmuGrJXVbNuzT9qBBavbLwCsOGabYfZo0T0to5eqruptLy" crossorigin="anonymous"></script>
<head>
    <meta charset="UTF-8">
    <title>Product Detail</title>
    <style>
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        .product-name h1{
            font-family: "Playfair Display",serif;
            font-size: 30pt;
            margin-top: 0;
        }
        .product-price {
            font-family: "Times New Roman",serif;
            font-size: 17pt;
        }
        .product-detail {
             display: flex;
             gap: 20px;
             align-items: flex-start;
             flex-wrap: wrap;
         }

        .product-image img {
            width: 100%;
            max-width: 600px;
            height: auto;
        }

        .product-carousel img {
            width: 80px;
            height: auto;
        }
        .product-carousel:hover img{
            transform: scale(1.1);
        }
        .product-info {
            flex: 1;
        }
        .product-description {
            font-family: "Verdana";
            font-size: 12pt;
            margin: 2px;
        }
        .product-section {
            font-family: "Times New Roman",serif;
            font-weight: bold;
            font-size: 15pt;
        }
        .block {
            display: block;
            width: 100%;
            border: none;
            background-color:#3b302a;
            color: white;
            padding: 14px 28px;
            font-size: 16px;
            cursor: pointer;
            text-align: center;
            border-radius: 10px;
        }
        .product-thumbnails {
            display: flex;
            flex-direction: column;
            gap: 10px;
        }
        @media (max-width: 768px) {
            .product-thumbnails {
                flex-direction: row;
                overflow-x: auto;
            }
        }

    </style>
</head>
<body>
<div class="container">
    <div class="product-detail">
        <?php
$images = is_array($product->image_url) ? $product->image_url : json_decode($product->image_url, true);
$firstImage = isset($images[0]) ? str_replace('\\','',$images[0]) : '/img/placeholder.png';
?>

<div class="product-thumbnails">
    <?php foreach ($images as $img): ?>
        <?php $imgUrl = $this->Url->image('products/' . basename(str_replace('\\','',$img))); ?>
        <div class="product-carousel">
            <img src="<?= h($imgUrl) ?>" onclick="changeImage('<?= h($imgUrl) ?>')">
        </div>
    <?php endforeach; ?>
</div>

<div class="product-image">
    <img id="main-image" src="<?= h($this->Url->image('products/' . basename($firstImage))) ?>">
</div>

        <div class="product-info">
            <div class="product-description", style="color: gray"><?= h($product->sku) ?></div>
            <div class="product-name">
            <h1><?= h($product->name) ?></h1>
            </div>
            <?php $hasSale = isset($product->sale_price) && $product->sale_price !== null && (float)$product->sale_price < (float)$product->price; $realPrice=0;?>
            <div class="product-description", style="color: gray"><?= h($product->category) ?></div>
            <div class="product-price">
            <p><?php if ($hasSale): ?>
                    <?php $realPrice = $product->sale_price ?>
                    <s style="color:gray">$<?= number_format($product->price,2)?></s> $<?= number_format($product->sale_price,2) ?>
                <?php else: ?>
                    <?php $realPrice = $product->price ?>
                    $<?= number_format($product->price,2) ?>
                <?php endif; ?></p>
            </div>
            <hr>
            <div class="product-description">
            <p><?= h($product->description) ?></p>
            </div>
            <hr>
            <div class="product-section">
                <?php if ($product->stock > 0): ?>
                    <p>We have <?= h($product->stock) ?> in stock</p>
                    <?= $this->Form->create(null, ['url' => ['controller' => 'ProductBrowser', 'action' => 'addToCart', $product->id]]) ?>
                    <p>Quantity&nbsp;&nbsp;
                        <input type="number" id="quantity" name="quantity" value="1" min="1" max="<?= h($product->stock) ?>" step="1"
                               oninput="if(this.value<1)this.value=1;if(this.value><?= h($product->stock) ?>)this.value=<?= h($product->stock) ?>">
                    </p>
                    &nbsp;
                    <?= $this->Form->button("Add to cart ($" . number_format($realPrice, 2) . ")", [
                        'class' => 'block',
                        'id' => 'button',
                        'type' => 'submit'
                    ]) ?>
                    <?= $this->Form->end() ?>
                <?php else: ?>
                    <p style="color: gray">Unavailable / Out of stock</p>
                    <button type="button" class="block" disabled style="background-color: gray;">Add to cart</button>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
</body>
</html>
<script>
    const price = <?= $realPrice ?>;
    const quantity = document.getElementById("quantity");
    const button = document.getElementById("button");
    function totalPrice() {
        const productQuantity = parseInt(quantity.value) || 1;
        const total = (productQuantity * price).toFixed(2);
        button.textContent = `Add to cart ($${total})`;
    }
    quantity.addEventListener("input", totalPrice);
    totalPrice();
    function changeImage(src) {
        document.getElementById("main-image").src = src;
    }
</script>