<?php /** @var \App\Model\Entity\User $user */ ?>
<h2>My Profile</h2>
<section>
  <p><strong>Name:</strong>
    <?= h(trim(($user->first_name ?? '') . ' ' . ($user->last_name ?? ''))) ?: '—' ?>
  </p>
  <p><strong>Email:</strong> <?= h($user->email) ?></p>
  <p><strong>Phone:</strong> <?= h($user->phone ?? '—') ?></p>
    <p><strong>Date of Birth:</strong>
        <?php
        use Cake\I18n\FrozenDate;
        if ($user->date_of_birth) {
            $dob = $user->date_of_birth instanceof FrozenDate
                ? $user->date_of_birth
                : new FrozenDate($user->date_of_birth);
            echo $dob->i18nFormat('dd MMM yyyy');
        } else {
            echo '—';
        }
        ?>
    </p>
  <?= $this->Html->link('Edit profile', ['action' => 'edit'], ['class' => 'button']) ?>
</section>

<hr>

<section>
  <h3>Your Preferences</h3>
  <?php if (empty($user->user_preferences)): ?>
    <p><em>No preferences saved.</em></p>
  <?php else: ?>
    <ul>
      <?php foreach ($user->user_preferences as $p): ?>
        <li><strong><?= h($p->pref_key) ?>:</strong> <?= h($p->pref_value) ?></li>
      <?php endforeach; ?>
    </ul>
  <?php endif; ?>

  <h4>Add / Update a Preference</h4>
  <?= $this->Form->create(null, ['url' => ['action' => 'savePreference']]) ?>
    <?= $this->Form->control('pref_key', ['label' => 'Key (e.g., roast, milk, size)']) ?>
    <?= $this->Form->control('pref_value', ['label' => 'Value (e.g., medium, oat, 12oz)']) ?>
    <?= $this->Form->button('Save preference') ?>
  <?= $this->Form->end() ?>
</section>

<hr>

<section>
  <h3>Past Orders</h3>
  <?php if (empty($user->orders)): ?>
    <p><em>No past orders.</em></p>
  <?php else: ?>
    <?php foreach ($user->orders as $o): ?>
      <div style="padding:10px;border:1px solid #eee;border-radius:8px;margin-bottom:12px;">
        <div>
          <strong>#<?= h($o->order_no ?? ('ORD-' . $o->id)) ?></strong>
          &nbsp; | &nbsp; <?= h($o->status ?? '—') ?>
          &nbsp; | &nbsp; $<?= number_format((float)($o->total ?? 0), 2) ?>
          <?php if ($o->created): ?>
            &nbsp; | &nbsp; <?= $o->created->i18nFormat('dd MMM yyyy') ?>
          <?php endif; ?>
        </div>
        <?php if (!empty($o->order_items)): ?>
          <ul style="margin:8px 0 0 18px;">
            <?php foreach ($o->order_items as $item): ?>
              <li><?= h($item->name) ?> × <?= (int)$item->qty ?> — $<?= number_format((float)$item->unit_price, 2) ?></li>
            <?php endforeach; ?>
          </ul>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</section>
