
<!DOCTYPE html>
<html lang="en">
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <meta name="csrfToken" content="<?= $this->request->getAttribute('csrfToken'); ?>">
    <?= $this->Html->css('normalize.min.css') ?>
    <?= $this->Html->css('home.css') ?>
    <?= $this->Html->css('contact.css') ?>
    <?= $this->Html->css('responsive.css') ?>
    <?= $this->Html->css('products') ?>
    <title><?= h($this->ContentBlock->text('site-title')) ?></title>

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;600;700&family=Inter:wght@300;400;500;600&display=swap" rel="stylesheet">
    <!-- Base + page styles -->
    <?= $this->Html->css(['normalize.min']) ?>
    <?= $this->Html->css(['home']) ?>
    <?= $this->fetch('css') ?>
    <?= $this->fetch('meta') ?>
    <?= $this->fetch('script') ?>
</head>
<body>
<header class="site-header">
    <div class="container header-inner">
        <div class="brand"><a href="/">BrewHub Coffee</a></div>
        <button class="nav-toggle" aria-expanded="false" aria-controls="site-nav">
          <span class="sr-only">Menu</span> ☰
        </button>
        <nav id="site-nav" class="nav">
            <?= $this->Html->link('Shop All', ['controller'=>'ProductBrowser','action'=>'index'], ['class'=>'nav-link']) ?>
            <?= $this->Html->link('About', '/#about') ?>  <!-- in-page jump -->
            <?= $this->Html->link('Contact', ['controller' => 'Contact', 'action' => 'index']) ?>

                <?php
                if (!$this->Identity->isLoggedIn()) {
                    echo $this->Html->link(
                        'Log in',
                        ['controller' => 'Auth', 'action' => 'login'],
                        ['class' => 'button button-outline']);
                }
                ?>
                <?php
                if ($this->Identity->isLoggedIn()) {
                    echo $this->Html->link('Logout', ['controller' => 'Auth', 'action' => 'logout']);
                }
                ?>
                <?php
                if ($this->Identity->isLoggedIn() && $this->Identity->get('role') != 'customer' ) {
                    echo $this->Html->link('Dashboard', ['controller' => 'Auth', 'action' => 'adminDashboard']);
                }
                ?>
        </nav>
        <div class="header-right">
          <?php
          $cart = (array)$this->getRequest()->getSession()->read('Cart');
          $count = array_sum($cart);
          ?>
          <?php if ($this->Identity->isLoggedIn()): ?>
            <?= $this->Html->link('Profile', ['controller' => 'Users', 'action' => 'profile'], ['class' => 'small-link', 'style' => 'margin-right:12px;']) ?>
          <?php endif; ?>
          <?= $this->Html->link('Cart ('.$count.')', ['controller' => 'Cart', 'action' => 'index'], ['class' => 'small-link']) ?>
        </div>
    </div>
</header>

<main>
    <?= $this->fetch('content') ?>
    <?= $this->Flash->render() ?>

</main>

<footer class="site-footer">
  <div class="container footer-main">
    <div class="footer-brand">BrewHub<br/>Coffee</div>

    <div class="footer-contact">
        <p><?= $this->ContentBlock->text('contact-phone') ?></p>
        <p><?= $this->ContentBlock->text('contact-email') ?></p>
        <p><?= $this->ContentBlock->text('contact-address') ?></p>
    </div>

    <div class="footer-right">
      <div class="footer-col">
        <ul class="footer-list">
          <li><a href="#">Privacy Policy</a></li>
          <li><a href="#">Accessibility Statement</a></li>
          <li><a href="#">Shipping Policy</a></li>
          <li><a href="#">Terms &amp; Conditions</a></li>
          <li><a href="#">Refund Policy</a></li>
        </ul>
      </div>
      <div class="footer-col">
        <ul class="footer-list">
          <li><a href="#">Facebook</a></li>
          <li><a href="#">Instagram</a></li>
          <li><a href="#">TikTok</a></li>
          <li><a href="#">YouTube</a></li>
        </ul>
      </div>
    </div>
  </div>

  <div class="container footer-bottom">
    <div class="footer-copy">© <?= date('Y') ?> BrewHub Coffee. Powered by WebSpire.</div>
  </div>
</footer>
<?= $this->element('brewbot_gemini'); ?>
<script>
(function () {
  const btn = document.querySelector('.nav-toggle');
  const nav = document.getElementById('site-nav');
  if (!btn || !nav) return;
  btn.addEventListener('click', () => {
    const open = btn.getAttribute('aria-expanded') === 'true';
    btn.setAttribute('aria-expanded', String(!open));
    nav.classList.toggle('open', !open);
    document.body.classList.toggle('no-scroll', !open);
  });
})();
</script>
</body>
</html>
