<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

class Product extends Entity
{
    protected array $_accessible = [
        'name' => true,
        'description' => true,
        'price' => true,
        'sku' => true,
        'stock' => true,
        'created' => true,
        'modified' => true,
        'image_url' => true,
        'threshold' => true,
        'category' => true,
        'sale_price' => true,
        'archived' => true,
    ];

    protected function _getImageUrl($value)
    {
        if (empty($value)) {
            return [];
        }
        return (is_array($value) ? $value : json_decode($value, true)) ?: [];
    }
}
