<?php
$this->assign('title', 'Forget Password');
?>
<style>
    .forget-wrapper {
        display:flex;
        justify-content:center;
        align-items:center;
        min-height:70vh;
        padding:20px;
    }
    .forget-card {
        background:#fff;
        border-radius:16px;
        box-shadow:0 8px 24px rgba(0,0,0,0.1);
        padding:40px;
        max-width:420px;
        width:100%;
        text-align:center;
    }
    .forget-title {
        font-family:"Playfair Display", serif;
        font-size:28px;
        margin-bottom:24px;
        color:#3b302a;
    }
    .forget-label {
        display:block;
        text-align:left;
        font-weight:500;
        margin-bottom:6px;
        color:#3b302a;
        font-size:14px;
    }
    .forget-input {
        width:100%;
        margin-bottom:16px;
        padding:10px 12px;
        border-radius:6px;
        border:1px solid #ccc;
    }
    .forget-btn {
        background-color:#3b302a;
        color:white;
        border:none;
        padding:12px;
        border-radius:8px;
        width:100%;
        font-size:16px;
        cursor:pointer;
        transition: background 0.3s;
    }
    .forget-btn:hover {
        background-color:#57463d;
    }
    .login-links {
        margin-top:20px;
        display:flex;
        flex-direction:column;
        gap:10px;
    }
    .login-links a {
        font-size:14px;
        color:#3b302a;
        text-decoration:underline;
    }
</style>

<div class="forget-wrapper">
    <div class="forget-card">
        <h2 class="forget-title">Forget Password</h2>

        <?= $this->Form->create() ?>
        <?= $this->Flash->render() ?>

        <p>Enter your email address below. You will receive an email with a password reset link.</p>

        <?= $this->Form->control('email', [
            'type'=>'email',
            'required'=>true,
            'autofocus'=>true,
            'label'=>'Email',
            'class'=>'forget-input',
            'templates' => [
                'label' => '<label class="forget-label">{{text}}</label>'
            ]
        ]) ?>

        <?= $this->Form->button('Send Reset Link', ['class'=>'forget-btn']) ?>
        <?= $this->Form->end() ?>

        <div class="login-links">
            <?= $this->Html->link('Back to login', ['controller'=>'Auth','action'=>'login']) ?>
        </div>
    </div>
</div>
