    <?php
    $this->assign('title', 'Order '.$order->order_no);
    ?>
    
    <h1 style="text-align:center; margin-bottom:20px">Order Details</h1>
    
    <div style="max-width:700px; margin:0 auto; padding:20px; background:#F5F0E7; border-radius:10px; box-shadow:0 4px 12px rgba(0,0,0,0.08)">
        <table style="width:100%; border-collapse:collapse; margin-bottom:20px">
            <tr>
                <th style="text-align:left; padding:10px; border-bottom:1px solid #ddd; width:150px">Order No</th>
                <td style="padding:10px; border-bottom:1px solid #ddd"><?= h($order->order_no) ?></td>
            </tr>
            <tr>
                <th style="text-align:left; padding:10px; border-bottom:1px solid #ddd">Customer</th>
                <td style="padding:10px; border-bottom:1px solid #ddd"><?= h($order->customer_name ?: '-') ?></td>
            </tr>
            <tr>
                <th style="text-align:left; padding:10px; border-bottom:1px solid #ddd">Email</th>
                <td style="padding:10px; border-bottom:1px solid #ddd"><?= h($order->email) ?></td>
            </tr>
            <tr>
                <th style="text-align:left; padding:10px; border-bottom:1px solid #ddd">Phone</th>
                <td style="padding:10px; border-bottom:1px solid #ddd"><?= h($order->phone ?: '-') ?></td>
            </tr>
            <tr>
                <th style="text-align:left; padding:10px; border-bottom:1px solid #ddd; vertical-align:top">Items</th>
                <td style="padding:10px; border-bottom:1px solid #ddd; line-height:1.6">
                    <table style="width:100%; border-collapse:collapse">
                        <thead>
                            <tr>
                                <th style="text-align:left; border-bottom:1px solid #ddd; padding:5px">Product</th>
                                <th style="text-align:right; border-bottom:1px solid #ddd; padding:5px">Qty</th>
                                <th style="text-align:right; border-bottom:1px solid #ddd; padding:5px">Price</th>
                                <th style="text-align:right; border-bottom:1px solid #ddd; padding:5px">Line Total</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($order->order_items as $it): ?>
                            <tr>
                                <td style="padding:5px"><?= h($it->name) ?></td>
                                <td style="text-align:right; padding:5px"><?= (int)$it->qty ?></td>
                                <td style="text-align:right; padding:5px">$<?= number_format((float)$it->unit_price, 2) ?></td>
                                <td style="text-align:right; padding:5px">$<?= number_format((float)$it->line_total, 2) ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </td>
            </tr>
            <tr>
                <th style="text-align:left; padding:10px; border-bottom:1px solid #ddd">Placed At</th>
                <td style="padding:10px; border-bottom:1px solid #ddd"><?= $order->created ? $order->created->format('d-m-Y H:i:s') : '' ?></td>
            </tr>
            <tr>
                <th style="text-align:left; padding:10px; border-bottom:1px solid #ddd">Status</th>
                <td style="padding:10px; border-bottom:1px solid #ddd"><?= h(ucfirst($order->status)) ?></td>
            </tr>
            <tr>
                <th style="text-align:left; padding:10px; border-bottom:1px solid #ddd">Subtotal</th>
                <td style="padding:10px; border-bottom:1px solid #ddd">$<?= number_format((float)$order->subtotal, 2) ?></td>
            </tr>
            <tr>
                <th style="text-align:left; padding:10px; border-bottom:1px solid #ddd">Total</th>
                <td style="padding:10px; border-bottom:1px solid #ddd">$<?= number_format((float)$order->total, 2) ?></td>
            </tr>
        </table>
    
        <div style="text-align:center; margin-top:20px">
            <div style="margin-top:10px">
                <?= $this->Form->postLink('Cancel Order', ['action'=>'cancel', $order->id], ['confirm'=>'Cancel this order?', 'class'=>'btn btn-danger', 'style'=>'margin-right:10px; padding:8px 16px; border-radius:6px']) ?>
                <?= $this->Html->link('Back to list', ['action'=>'adminIndex'], ['class'=>'btn btn-secondary', 'style'=>'padding:8px 16px; border-radius:6px']) ?>
            </div>
        </div>
    </div>
