<?php
$this->assign('title', h($landing->hero_title));
?>

<section class="hero">
    <div class="container hero-inner">
        <div class="hero-text">
            <h1><?= h($landing->hero_title) ?></h1>
            <p class="lead"><?= h($landing->hero_subtitle) ?></p>
            <a class="btn" href="/ProductBrowser/">Shop Now</a>
        </div>
        <div class="hero-images">
            <?= $this->Html->image('hero-pour.jpg', ['alt' => 'Pour over', 'class' => 'img']) ?>
            <?= $this->Html->image('hero-roast.jpg', ['alt' => 'Roasting coffee', 'class' => 'img']) ?>
        </div>
    </div>
</section>

<section class="favorites">
    <div class="container">
        <h2 class="section-title">Our Favourites</h2>
        <div class="product-row">
            <?php foreach ($featuredProducts as $product): ?>
                <?php
                $images = is_array($product->image_url) ? $product->image_url : json_decode($product->image_url, true);
                $firstImage = isset($images[0]) ? str_replace('\\', '', $images[0]) : 'placeholder.png';
                $firstImage = preg_replace('#^/team212-app_fit3047/img/#', '', $firstImage);
                ?>
                <div class="product-card" onclick="location.href='<?= $this->Url->build(['controller' => 'Products', 'action' => 'detail', $product->id]) ?>'" style="cursor:pointer;">
                    <img src="<?= $this->Url->image('products/' . basename($firstImage)) ?>" alt="<?= h($product->name) ?>" class="img">
                    <h3><?= h($product->name) ?></h3>
                    <p>$<?= number_format($product->price, 2) ?></p>
                </div>
            <?php endforeach; ?>

        </div>
    </div>
</section>



<section class="promo">
    <div class="container promo-inner">
        <div class="promo-text">
            <div class="eyebrow">Special Offer for Limited Time</div>
            <h3><?=h($landing->promo_copy)?></h3>
            <a class="btn btn-small" href="/ProductBrowser/">Shop Now</a>
        </div>
        <div class="promo-media">
            <?= $this->Html->image('tasting.jpg', ['alt' => 'Tasting bar', 'class' => 'img']) ?>
        </div>
    </div>
</section>

<section class="story" id="about">
    <div class="container story-grid">
        <div>
            <div class="eyebrow">Our Story</div>
            <h3>We hold ourselves up to the highest of standards, and have been part of this industry since 2000.</h3>
            <p>We supply many local and global companies with a variety of innovative products, created with the greatest degree of precision and care.</p>
        </div>
        <div>
            <?= $this->Html->image('farm.jpg', ['alt' => 'Coffee farm', 'class' => 'img']) ?>
        </div>
    </div>
</section>

