<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Product> $products
 */
?>
<h1 style="text-align: center" class="headline">Archived Products</h1>
<div style="text-align: center; margin-bottom: 10px;">
    <?= $this->Html->link(__('Go Back'), ['action' => 'index'],  ['class' => 'button', 'style' => 'padding:10px 20px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;']) ?>
</div>
<style>
    div.dt-container {
        margin: 0 auto;
        width: 90%;
    }
    table.dataTable td {
        white-space: nowrap;
    }
    .headline {
        font-family: "Playfair Display",serif;
    }
</style>
<link rel="stylesheet" href="https://cdn.datatables.net/2.3.4/css/dataTables.dataTables.css" />
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/3.0.3/css/responsive.dataTables.min.css" />
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/2.3.4/js/dataTables.js"></script>
<script scr="https://cdn.datatables.net/2.3.4/css/dataTables.dataTables.css"></script>
<script src="https://cdn.datatables.net/responsive/3.0.3/js/dataTables.responsive.min.js"></script>
<div style="display: flex; justify-content: center">
    <table id="Table" class="display">
        <thead>
        <tr>
            <th><?= $this->Paginator->sort('id') ?></th>
            <th><?= $this->Paginator->sort('name') ?></th>
            <th><?= $this->Paginator->sort('price') ?></th>
            <th><?= $this->Paginator->sort('sku') ?></th>
            <th><?= $this->Paginator->sort('stock') ?></th>
            <th><?= $this->Paginator->sort('created') ?></th>
            <th><?= $this->Paginator->sort('modified') ?></th>
            <th class="actions"><?= __('Actions') ?></th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($products as $product): ?>
            <tr>
                <td><?= $this->Number->format($product->id) ?></td>
                <td><?= h($product->name) ?></td>
                <td><?= $this->Number->format($product->price) ?></td>
                <td><?= h($product->sku) ?></td>
                <td>
                    <?= $product->stock === null ? '' : $this->Number->format($product->stock) ?>
                    <?php
                    if ($product->stock === null) {
                        echo '';
                    } else {
                        if ($product->stock <= $product->threshold) {
                            echo ' <span style="color:red; font-weight:bold;">(Low stock!)</span>';
                        }
                    }
                    ?>
                </td>
                <td><?= h($product->created) ?></td>
                <td><?= h($product->modified) ?></td>
                <td class="actions">
                    <?= $this->Html->link(__('View'), ['action' => 'view', $product->id], ['class' => 'button', 'style' => 'padding:5px 10px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;']) ?>
                    <?= $this->Form->postLink(
                        __('Unarchive'),
                        ['action' => 'unArchive', $product->id],
                        [
                            'class' => 'button',
                            'style' => 'padding:5px 10px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;',
                        ]
                    ) ?>
                    <?= $this->Form->postLink(
                        __('Delete'),
                        ['action' => 'delete', $product->id], ['class' => 'button','confirm' => __('Are you sure you want to delete # {0}?', $product->id),'style' => 'padding:5px 10px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;'],
                    ) ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
    $(document).ready(function () {
        $('#Table').DataTable({
            responsive: true,
            paging: true,
            searching: true,
            ordering: true,
            info: true,
            lengthMenu: [10, 25, 50, 100]
        });
    });
</script>
