<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Product $product
 */
?>
<div class="row" style="max-width: 1100px; margin: 20px auto; padding: 10px">
    <div class="column column-100">
        <div class="products view content" style="background:#F5F0E7; padding:20px; border-radius:10px; box-shadow:0 4px 12px rgba(0,0,0,0.08)">
            <h2 style="text-align:center; margin-bottom:20px"><?= h($product->name) ?></h2>

            <?php if (!empty($product->image_url)) : ?>
                <div class="product-images">
                    <div class="image-gallery" style="display:flex; flex-wrap:wrap; gap:12px; justify-content:center; margin-bottom:20px">
                        <?php foreach ($product->image_url as $img) : ?>
                            <?php 
                                $cleanPath = str_replace('\\', '/', $img);
                                $imgUrl = $this->Url->image('products/' . basename($cleanPath), ['fullBase' => true]);
                            ?>
                            <div class="image-item" style="flex:1 1 120px; max-width:160px">
                                <img src="<?= h($imgUrl) ?>" alt="<?= h($product->name) ?>"
                                     style="width:100%; height:150px; object-fit:cover; border-radius:8px; cursor:pointer"
                                     onclick="openImageModal('<?= h($imgUrl) ?>')" />
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>
            <table style="width:100%; border-collapse:collapse; margin-bottom:20px">
                <tr>
                    <th style="text-align:left; padding:8px; border-bottom:1px solid #ddd"><?= __('Name') ?></th>
                    <td style="padding:8px; border-bottom:1px solid #ddd"><?= h($product->name) ?></td>
                </tr>
                <tr>
                    <th style="text-align:left; padding:8px; border-bottom:1px solid #ddd"><?= __('Sku') ?></th>
                    <td style="padding:8px; border-bottom:1px solid #ddd"><?= h($product->sku) ?></td>
                </tr>
                <tr>
                    <th style="text-align:left; padding:8px; border-bottom:1px solid #ddd"><?= __('Price') ?></th>
                    <td style="padding:8px; border-bottom:1px solid #ddd"><?= $this->Number->format($product->price) ?></td>
                </tr>
                <tr>
                    <th style="text-align:left; padding:8px; border-bottom:1px solid #ddd"><?= __('Sale Price') ?></th>
                    <td style="padding:8px; border-bottom:1px solid #ddd"><?= $product->sale_price === null ? '-' : $this->Number->format($product->sale_price) ?></td>
                </tr>
                <tr>
                    <th style="text-align:left; padding:8px; border-bottom:1px solid #ddd"><?= __('Stock') ?></th>
                    <td style="padding:8px; border-bottom:1px solid #ddd"><?= $product->stock === null ? '-' : $this->Number->format($product->stock) ?></td>
                </tr>
                <tr>
                    <th style="text-align:left; padding:8px; border-bottom:1px solid #ddd"><?= __('Threshold') ?></th>
                    <td style="padding:8px; border-bottom:1px solid #ddd"><?= $product->threshold === null ? '-' : $this->Number->format($product->threshold) ?></td>
                </tr>
                <tr>
                    <th style="text-align:left; padding:8px; border-bottom:1px solid #ddd"><?= __('Category') ?></th>
                    <td style="padding:8px; border-bottom:1px solid #ddd"><?= h($product->category) ?></td>
                </tr>
                <tr>
                    <th style="text-align:left; padding:8px; border-bottom:1px solid #ddd"><?= __('Created') ?></th>
                    <td style="padding:8px; border-bottom:1px solid #ddd"><?= h($product->created) ?></td>
                </tr>
                <tr>
                    <th style="text-align:left; padding:8px; border-bottom:1px solid #ddd"><?= __('Modified') ?></th>
                    <td style="padding:8px; border-bottom:1px solid #ddd"><?= h($product->modified) ?></td>
                </tr>
            </table>

            <div class="text" style="margin-top:20px">
                <h4><?= __('Description') ?></h4>
                <p style="line-height:1.6; color:#444"><?= $this->Text->autoParagraph(h($product->description)); ?></p>
            </div>
        </div>
    </div>
</div>

<div id="imageModal" style="display:none; position:fixed; z-index:1000; left:0; top:0; width:100%; height:100%; background:rgba(0,0,0,0.85); cursor:pointer" onclick="closeImageModal()">
    <div style="position:absolute; top:50%; left:50%; transform:translate(-50%, -50%)">
        <img id="modalImage" style="max-width:90vw; max-height:90vh; border-radius:8px" />
        <div style="text-align:center; color:white; margin-top:10px">
            <span onclick="closeImageModal()" style="background:rgba(255,255,255,0.25); padding:8px 16px; border-radius:6px; cursor:pointer"><?= __('Close') ?></span>
        </div>
    </div>
</div>

<script>
function openImageModal(src) {
    document.getElementById('modalImage').src = src
    document.getElementById('imageModal').style.display = 'block'
}
function closeImageModal() {
    document.getElementById('imageModal').style.display = 'none'
}
</script>
