<?php
declare(strict_types=1);

/**
 * Application-local configuration.
 * This file is for settings specific to your machine (dev).
 * No closing PHP tag on purpose.
 */

return [
    // Enable/disable debug mode
    'debug' => filter_var(env('DEBUG', true), FILTER_VALIDATE_BOOL),

    // Security salt (use a long random string in production or via .env)
    'Security' => [
        'salt' => env('SECURITY_SALT', 'dev-change-this-salt-please'),
    ],

    // Optional app defaults
    'App' => [
        'encoding' => 'UTF-8',
        'defaultLocale' => env('APP_DEFAULT_LOCALE', 'en_AU'),
        'defaultTimezone' => env('APP_DEFAULT_TIMEZONE', 'UTC'),
    ],

    /**
     * Database connections
     */
    'Datasources' => [
        'default' => [
            'className' => \Cake\Database\Connection::class,
            'driver' => \Cake\Database\Driver\Mysql::class,
            'host' => 'localhost',    // use TCP, avoids socket auth issues
            'port' => 3306,           // keep 3306 (Homebrew/XAMPP). If you use MAMP, it's 8889.
            'username' => 'aaronbrwl',
            'password' => 'the_password',
            'database' => 'u25s2212_brewhub',
            'encoding' => 'utf8mb4',
            'timezone' => 'UTC',

            'cacheMetadata' => true,
            'log' => false,
      ],
    ],

    /**
     * Email (dev-friendly)
     * - 'debug' transport writes emails to logs/email.log
     */
    'EmailTransport' => [
        'internal' => [
            'className' => 'Smtp',
            'host' => 'localhost',
            'port' => 25,
            'timeout' => 30,
            'username' => 'brewhub@u25s2212.iedev.org',
            'password' => 'brewHub_123',
            'client' => null,
            'tls' => false,
        ],
    ],
    'Email' => [
        'internal' => [
            'transport' => 'internal',
            'from' => ['brewhub@u25s2212.iedev.org' => 'BrewHub'],
            'charset' => 'utf-8',
            'headerCharset' => 'utf-8',
        ],
    ],

    // Captcha keys (as generated by Google)
    'Recaptcha' => [
        'site' => '6LctTa8rAAAAAAnEmVweUVqMYvKsJNGjK7jV6CRo',
        'secret' => '6LctTa8rAAAAAFLxB0W8mO91JUR8fz0ZiruD8qRl',
    ],

    // Stripe keys
    'Stripe' => [
        'secret' => 'sk_test_51SCVgPPa9JZUcJkFPqjmOD1oAGwX5iIBMzwhtk5Yw52V0uNrq6TTlB1AKnqFzaFGZHS4BdUUQIeoBiQpvvR0OL7O0069Vwh2Nb',
        'publishable' => 'pk_test_51SCVgPPa9JZUcJkF6mrCJe2DRZngsdTM5GFCrvD2mEZg0qZel8AsQS3LQb5gtUs5x7goKGQ6DjQ9OoDo6TKh9C9f005IaxDRsx',
        'webhook_secret' => 'whsec_Typa3IdqXsBsxRq6wcZxdg1tlmuoWENB', // using review.u25s2212.iedev.org
    ],

    /**
     * Custom app settings
     */
    'Store' => [
        // Where the contact form should send/notify
        'contactEmail' => env('STORE_CONTACT_EMAIL', 'info@brewhub.local'),
    ],
];
