<?php


declare(strict_types=1);

namespace App\Controller;

use App\Form\ContactForm;
use App\Model\Entity\ContactSubmission;
use Cake\Mailer\Mailer;
class ContactController extends AppController
{
    private $ContactSubmissions;
    public function initialize(): void
    {
        parent::initialize();
        $this->ContactSubmissions = $this->fetchTable('ContactSubmissions');
        $this->Authentication->allowUnauthenticated(['index','thanks']);
    }

    public function index()
    {
        $form = new ContactForm();
        if ($this->request->is('post')) {
            $data = $this->request->getData();
            if ($form->execute($data)) {
                $submission = $this->ContactSubmissions->newEmptyEntity();
                $submission = $this->ContactSubmissions->patchEntity($submission, $data);
                $this->ContactSubmissions->save($submission);
                $mailer = new Mailer('internal');
                $mailer->setTo('brewhub@u25s2212.iedev.org')
                    ->setSubject('New Contact Form Submission')
                    ->deliver(
                        "Name: {$data['first_name']} {$data['last_name']}\n" .
                        "Email: {$data['email']}\n" .
                        "Phone: {$data['phone']}\n" .
                        "Message:\n{$data['message']}"
                    );
                $session = $this->request->getSession();
                $session->write('Contact.first_name', $data['first_name'] ?? '');
                return $this->redirect(['action' => 'thanks']);
            }
            $this->Flash->error('Please fill the field below and try again.');
        }
        $this->set(compact('form'));
    }
    public function delete($id = null)
        {
            $this->request->allowMethod(['post', 'delete']);
            $submission = $this->ContactSubmissions->get($id);
            $this->ContactSubmissions->delete($submission);
            return $this->redirect(['controller' => 'Auth', 'action' => 'inquiries']);
        }

    public function view($id = null)
    {
        $submission = $this->ContactSubmissions->get($id);
        $this->set(compact('submission'));
    }

    public function updateStatus($id)
    {
        $submission = $this->ContactSubmissions->get($id);
        if ($this->request->is(['post', 'put'])) {
            $submission->status = $this->request->getData('status');
            $this->ContactSubmissions->save($submission);
        }
        return $this->redirect($this->referer());
    }

    public function updateNote($id = null)
    {
        $this->request->allowMethod(['post', 'GET']);
        $submission = $this->ContactSubmissions->get($id);
        $note = $this->request->getData('note');
        $submission->note = $note;
        $this->ContactSubmissions->save($submission);
        return $this->redirect(['controller' => 'Auth', 'action' => 'adminDashboard']);
    }

    public function thanks()
    {
        // Read & clear the name so the page refresh doesn’t keep it forever
        $session = $this->request->getSession();
        $name = (string)$session->read('Contact.first_name');
        $session->delete('Contact.first_name');

        $this->set(compact('name'));
    }
}

