<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\LandingPage $landing
 */
?>
<style>
    .form input,
    .form textarea,
    .form select {
        display: block;
        width: 100%;
        margin-bottom: 15px;
    }
    .landing-container {
        margin-left: 300px;
        margin-right: 300px;
    }
    .flex-row {
        display: flex;
        gap: 10px;
    }
    .flex-row > div {
        flex: 1;
    }
    .landing-container {
        margin-left: auto;
        margin-right: auto;
        max-width: 800px;
        padding: 0 15px;
    }
    .headline {
    font-family: "Playfair Display",serif;
    }
    @media (max-width: 768px) {
        .flex-row {
            flex-direction: column;
        }
    }
</style>

<div class="landing-container">
    <h1 style="text-align: center" class="headline">Edit Landing Page</h1>
    <?= $this->Form->create($landing) ?>
    <fieldset>
        <legend>Landing Page Content</legend>
        <div class="flex-row">
            <div>
                <label>Hero Title</label>
                <?= $this->Form->control('hero_title', ['label' => false]) ?>
            </div>
            <div>
                <label>Hero Subtitle</label>
                <?= $this->Form->control('hero_subtitle', ['label' => false]) ?>
            </div>
        </div>

        <div class="flex-row">
            <div>
                <label>Promotional Copy</label>
                <?= $this->Form->control('promo_copy', ['type' => 'textarea', 'rows' => 5, 'label' => false]) ?>
            </div>
            <div>
                <label>Featured Products (comma-separated IDs)</label>
                <?= $this->Form->control('featured_products', ['label' => false]) ?>
            </div>
        </div>
    </fieldset>
    <br>
    <?= $this->Form->button(__('Save')) ?>
    <?= $this->Form->end() ?>

</div>
<br><br><br>
