<h1 style="text-align: center" class="headline">Manage Inquiries</h1>

<style>
    div.dt-container {
    margin: 0 auto;
    width: 80%;
    }
    table.dataTable td {
     white-space: nowrap;
    }
    .headline {
    font-family: "Playfair Display",serif;
    }
</style>
<link rel="stylesheet" href="https://cdn.datatables.net/2.3.4/css/dataTables.dataTables.css" />
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/3.0.3/css/responsive.dataTables.min.css" />
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/2.3.4/js/dataTables.js"></script>
<script src="https://cdn.datatables.net/2.3.4/css/dataTables.dataTables.css"></script>
<script src="https://cdn.datatables.net/responsive/3.0.3/js/dataTables.responsive.min.js"></script>
<div style="display: flex; justify-content: center">
    <table id="submissionsTable" class="display">
        <thead>
        <tr>
            <th>Name</th>
            <th>Email</th>
            <th>Submitted At</th>
            <th>Status</th>
            <th>Note</th>
            <th>Actions</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($submissions as $submission): ?>
            <tr>
                <td><?= h("{$submission->first_name} {$submission->last_name}") ?></td>
                <td><?= h($submission->email) ?></td>
                <td><?= h($submission->created->format('d-m-Y H:i:s')) ?></td>
                <td>
                    <?= $this->Form->create(null, [
                        'url' => ['controller' => 'Contact', 'action' => 'updateStatus', $submission->id],
                        'class' => 'd-inline'
                    ]) ?>
                    <?= $this->Form->select(
                        'status',
                        ['New' => 'New', 'In Progress' => 'In Progress', 'Resolved' => 'Resolved', 'Archived' => 'Archived'],
                        ['value' => $submission->status, 'onchange' => 'this.form.submit()', 'class' => 'form-select']
                    ) ?>
                    <?= $this->Form->end() ?>
                </td>
                <td>
                    <button onclick="document.getElementById('noteModal<?= $submission->id ?>').style.display='block'" type="button" style="padding:5px 10px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;">View/Edit Note</button>
                    <div id="noteModal<?= $submission->id ?>" style="display:none; position:fixed; top:20%; left:35%; background:#fff; border:1px solid #000; padding:20px; z-index:1000;">
                        <?= $this->Form->create($submission, [
                            'url' => ['controller' => 'Contact', 'action' => 'updateNote', $submission->id],
                            'method' => 'post'
                        ]) ?>
                        <?= $this->Form->control('note', ['type' => 'textarea', 'rows' => 5, 'cols' => 40, 'value' => $submission->note, 'label'=>false]) ?>
                        <?= $this->Form->button('Save', ['type' => 'submit', 'style' => 'padding:5px 10px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;']) ?>
                        <button type="button" onclick="document.getElementById('noteModal<?= $submission->id ?>').style.display='none'" style="padding:5px 10px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;">Close</button>
                        <?= $this->Form->end() ?>
                    </div>
                </td>
                <td class="text-center">
                    <?= $this->Html->link(
                        'View',
                        ['controller' => 'Contact', 'action' => 'view', $submission->id],
                        ['class' => 'button', 'style' => 'padding:5px 10px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;']
                    ) ?>
                    <?= $this->Form->postLink(
                        'Remove',
                        ['controller' => 'Contact', 'action' => 'delete', $submission->id],
                        ['class' => 'button', 'style' => 'padding:5px 10px; font-size:16px; text-decoration:none; background-color:#3b302a; color:white; border-radius:5px;', 'confirm' => 'Are you sure you want to delete this message?']
                    ) ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
    $(document).ready(function () {
        $('#submissionsTable').DataTable({
            responsive: true,
            paging: true,
            searching: true,
            ordering: true,
            info: true,
            lengthMenu: [10, 25, 50, 100]
        });
    });
</script>

