<?php
/** @var \App\Form\ContactForm $form */
$this->assign('title', 'Contact Us');
$this->Html->css(['contact'], ['block' => true]); // loads webroot/css/contact.css
?>

<section class="contact-page">
  <div class="container">
    <h1 class="contact-title">Contact Us</h1>
    <p class="contact-subtitle">
      Interested in placing an order or learning more?<br>
      Simply reach out today
    </p>

    <?= $this->Flash->render() ?>

    <?= $this->Form->create($form, ['novalidate' => true, 'class' => 'contact-form']) ?>

      <div class="grid-2">
        <div class="field">
          <?= $this->Form->label('first_name', 'First name *') ?>
          <?= $this->Form->control('first_name', [
                'label' => false,
                'templates' => ['inputContainer' => '{{content}}'],
                'aria-required' => 'true',
          ]) ?>
        </div>

        <div class="field">
          <?= $this->Form->label('last_name', 'Last name *') ?>
          <?= $this->Form->control('last_name', [
                'label' => false,
                'templates' => ['inputContainer' => '{{content}}'],
                'aria-required' => 'true',
          ]) ?>
        </div>
      </div>

      <div class="field">
        <?= $this->Form->label('email', 'Email *') ?>
        <?= $this->Form->control('email', [
              'label' => false,
              'templates' => ['inputContainer' => '{{content}}'],
              'aria-required' => 'true',
        ]) ?>
      </div>

      <div class="field">
        <?= $this->Form->label('phone', 'Phone') ?>
        <?= $this->Form->control('phone', [
              'label' => false,
              'type' => 'tel',
              'templates' => ['inputContainer' => '{{content}}'],
        ]) ?>
      </div>

      <div class="field">
        <?= $this->Form->label('message', 'Message *') ?>
        <?= $this->Form->control('message', [
              'label' => false,
              'rows' => 5,
              'templates' => ['inputContainer' => '{{content}}'],
              'aria-required' => 'true',
        ]) ?>
      </div>

      <!-- Honeypot for bots -->
      <div style="display:none">
        <?= $this->Form->control('website', ['label' => 'Website']) ?>
      </div>

      <!-- Google reCAPTCHA v2 -->
      <div class="field">
          <!-- if CAPTCHA is not filled, throw error -->
          <div class="field <?= $this->Form->isFieldError('g-recaptcha-response') ? 'has-error' : '' ?>">
              <div class="g-recaptcha" data-sitekey="<?= h(\Cake\Core\Configure::read('Recaptcha.site')) ?>"></div>
          </div>

          <!-- Let Cake render the validator message -->
          <?= $this->Form->error('g-recaptcha-response', null, ['class' => 'error']) ?>

          <div class="actions">
          <button class="btn" type="submit">Submit</button>
      </div>

      <?= $this->Form->end() ?>

      <!-- Google reCAPTCHA script -->
      <script src="https://www.google.com/recaptcha/api.js" async defer></script>

  </div>
</section>
