<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Product Detail</title>
    <style>
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        .product-name {
            font-family: "Playfair Display",serif;
            font-size: 20pt;
        }
        .product-price {
            font-family: "Times New Roman",serif;
            font-size: 16pt;
        }
        .product-detail {
            display: flex;
            gap: 40px;
            align-items: flex-start;
            flex-wrap: nowrap;
        }
        .product-image img {
            width: 500px;
            height: auto;
            border: 1px solid #ccc;
        }
        .product-info {
            flex: 1;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="product-detail">
        <div class="product-image">
            <img src="<?= h($product->product_images[0]->image_url) ?>" alt="<?= h($product->product_images[0]->image_url) ?>">
        </div>
        <div class="product-info">
            <div class="product-name">
            <h1><?= h($product->name) ?></h1>
            </div>
            <div class="product-price"
            <p>$<?= h($product->price) ?></p>
            </div>
        <p><?= h($product->description) ?></p>
        </div>
    </div>
</div>
</body>
</html>

