<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Product $product
 */
?>
<style>
    .form input,
    .form textarea,
    .form select {
        display: block;
        width: 100%;
        margin-bottom: 15px;
    }
    .existing-images .image-container {
        display: inline-block;
        margin: 5px;
        text-align: center;
    }
    .existing-images .image-container img {
        width: 100px;
        height: 100px;
    }
    .existing-images .image-container input[type="checkbox"] {
        margin-top: 5px;
    }
    .row {
        margin-left: auto;
        margin-right: auto;
        max-width: 900px;
        padding: 0 15px;
    }
    @media (max-width: 768px) {
        .row {
            max-width: 100%;
            padding: 0 10px;
        }
    }
</style>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $product->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $product->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Products'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="products form content">
            <?= $this->Form->create($product, ['type' => 'file']) ?>
            <fieldset>
                <legend><?= __('Edit Product') ?></legend>
                <div style="display:flex; gap:10px; flex-wrap:wrap;">
                    <div style="flex:1; min-width:100px;">
                        <?= $this->Form->control('name',['required'=>true]) ?>
                    </div>
                    <div style="flex:1; min-width:100px;">
                        <?= $this->Form->control('price',['type'=>'number','required'=>true,'min'=>0,'max'=>999]) ?>
                    </div>
                    <div style="flex:1; min-width:100px;">
                        <?= $this->Form->control('sale_price',['type'=>'number','min'=>0,'max'=>999]) ?>
                    </div>
                    <div style="flex:1; min-width:100px;">
                        <?= $this->Form->control('sku',['required'=>true]) ?>
                    </div>
                    <div style="flex:1; min-width:100px;">
                        <?= $this->Form->control('stock',['type'=>'number','required'=>true,'min'=>0,'max'=>99999]) ?>
                    </div>
                    <div style="flex:1; min-width:100px;">
                        <?= $this->Form->control('threshold',['min'=>0,'max'=>1000,'required'=>true]) ?>
                    </div>
                    <div style="flex:1; min-width:100px;">
                        <?= $this->Form->control('category', [
                            'type' => 'select',
                            'options' => ['Blends' => 'Blends', 'Single-Origin' => 'Single-Origin', 'Sustainable' => 'Sustainable'],
                            'required' => true
                        ]) ?>
                    </div>
                </div>
                <?= $this->Form->control('description',['required'=>true]) ?>
                <?php
                if (!empty($product->image_url)) {
                    echo '<div class="existing-images">';
                    echo '<h4>Current Images (select to delete)</h4>';
                    foreach ($product->image_url as $img) {
                        $cleanPath = str_replace('\\', '/', $img);
                        $imgUrl = $this->Url->image('products/' . basename($cleanPath), ['fullBase' => true]);
                        echo '<div class="image-container">';
                        echo '<img src="' . h($imgUrl) . '" />';
                        echo '<br><input type="checkbox" name="delete_images[]" value="' . h($img) . '">';
                        echo '</div>';
                    }
                    echo '</div>';
                }
                echo $this->Form->control('image_url[]', [
                    'type' => 'file',
                    'multiple' => true,
                    'label' => 'New Images',
                    'required' => false,
                    'accept' => 'image/*'
                ]);
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
