<?php
/**
 * @var \Cake\View\View $this
 * @var string $img
 * @var string $title
 * @var string $price
 * @var string|null $compare
 * @var string|null $badge
 */
?>
<article class="product-card">
    <?php if (!empty($badge)): ?>
        <span class="badge"><?= h($badge) ?></span>
    <?php endif; ?>
    <div class="product-media">
        <?= $this->Html->image($img, ['alt' => $title]) ?>
    </div>
    <h4 class="product-title"><?= h($title) ?></h4>
    <div class="product-price">
        <?php if (!empty($compare)): ?>
            <span class="compare"><?= h($compare) ?></span>
        <?php endif; ?>
        <span><?= h($price) ?></span>
    </div>
</article>

